%
% 20.109 Edge Detector Module
%
% Compute Transfer Functions and Compositions
clear all; close all;
%%
%
% pIPTG_LacZ
%
load pIPTG_LacZ_input_range;
load pIPTG_LacZ_output;

pIPTG_LacZ_input_range_log10 = log10(pIPTG_LacZ_input_range);
pIPTG_LacZ_output_log10      = log10(pIPTG_LacZ_output);
%%
figure('Name', 'pIPTG_LacZ: IPTG -> LacZ');
cf_pIPTG_LacZ = edge_detection_tf_fit_pIPTG_LacZ(pIPTG_LacZ_input_range_log10, pIPTG_LacZ_output_log10);

%%
%
% pJT103
%
load pJT103_light_input_range;
load pJT103_LacZ_output;

pJT103_light_input_range_log10 = log10(pJT103_light_input_range);
pJT103_LacZ_output_log10       = log10(pJT103_LacZ_output);

figure('Name', 'pJT103: Light -> LacZ');
cf_pJT103 = edge_detection_tf_fit_pJT103(pJT103_light_input_range_log10, pJT103_LacZ_output_log10);

%%
%
% Compute light->IPTG transfer function
%

% first, compute Miller Units range 
% (note that these functions have opposite slopes)
tf_bottom = max([cf_pJT103.Top    cf_pIPTG_LacZ.Bottom]);
tf_top    = min([cf_pJT103.Bottom cf_pIPTG_LacZ.Top]);

IPTG_range_log10  = min(pIPTG_LacZ_input_range_log10)  :0.01:max(pIPTG_LacZ_input_range_log10);
light_range_log10 = min(pJT103_light_input_range_log10):0.01:max(pJT103_light_input_range_log10);

IPTG_tf  = zeros(size(IPTG_range_log10,2),2);
light_tf = zeros(size(light_range_log10,2),2);

% create array with IPTG tranfer function values
for i=1:size(IPTG_tf,1)
    IPTG_tf(i,1) = IPTG_range_log10(i);
    IPTG_tf(i,2) = feval(cf_pIPTG_LacZ, IPTG_range_log10(i));
end

% create array with light tranfer function values
for i=1:size(light_tf,1)
    light_tf(i,1) = light_range_log10(i);
    light_tf(i,2) = feval(cf_pJT103, light_range_log10(i));
end

figure('Name', 'Curve fit: pIPTG_LacZ'); plot(IPTG_tf(:,1),IPTG_tf(:,2)); 
xlabel('IPTG'); ylabel('Miller Units'); title('IPTG to Miller Units');

figure('Name', 'Curve fit: pJT103'); plot(light_tf(:,1),light_tf(:,2));
xlabel('Light'); ylabel('Miller Units'); title('Light to Miller Units');

% now, actually create the light->IPTG tf by scanning both TF's and
% choosing a best match when appropriate
k=1;
last_IPTG_index = 1;
light_to_IPTG = [];
for j=1:size(light_tf,1)
    if (light_tf(j,2) > tf_bottom)
        if (light_tf(j,2) < tf_top)
            m = size(IPTG_tf,1);
            prev_IPTG_miller_units = IPTG_tf(m,2);
            m = m-1;
            while (m > 1) && ...
                    (abs(prev_IPTG_miller_units - light_tf(j,2)) >= ...
                     abs(IPTG_tf(m,2) - light_tf(j,2)))
                 prev_IPTG_miller_units = IPTG_tf(m,2);
                 m = m - 1;                 
            end
            % store in rows <light,IPTG,miller>
%            disp(['best match for light/miller ' num2str(light_tf(j,1)) '/' num2str(light_tf(j,2)) ...
%                ' is IPTG at position ' num2str(m) ': IPTG/miller ' ...
%                num2str(IPTG_tf(m,1)) ',' num2str(IPTG_tf(m,2))]);
            light_to_IPTG(k,1) = light_tf(j,1);
            light_to_IPTG(k,2) = IPTG_tf (m,1);
            light_to_IPTG(k,3) = light_tf(j,2);
            k = k + 1;
        else 
%           disp(['light position ' num2str(j) ' more than top']);
        end
    else 
%        disp(['light position ' num2str(j) ' less than bottom.  light/miller = ' ...
%            num2str(light_tf(j,1)) ',' num2str(light_tf(j,2))]);
    end
end

figure('Name', 'Light to IPTG conversion'); 
plot(light_to_IPTG(:,1), light_to_IPTG(:,2));
title('Light to IPTG');
xlabel('Light');
ylabel('IPTG');

%%
%
% Determine surface function for pED_IPTG_INS and pED_IPTG_fixed
%
load AHL_input_pED_IPTG_INS;
load IPTG_input_pED_IPTG_INS;
load LacZ_output_pED_IPTG_INS;

AHL_input_pED_IPTG_INS_log10   = log10(AHL_input_pED_IPTG_INS);
IPTG_input_pED_IPTG_INS_log10  = log10(IPTG_input_pED_IPTG_INS);
LacZ_output_pED_IPTG_INS_log10 = log10(LacZ_output_pED_IPTG_INS);
    
%[pED_IPTG_INS_fit, gof_1] = edge_detection_surface_fit_pLux_cI(AHL_input_pED_IPTG_INS_log10, ...
%     IPTG_input_pED_IPTG_INS_log10, LacZ_output_pED_IPTG_INS_log10, 'IPTG', ...
%     start_vals);

  [pED_IPTG_INS_fit, gof_1] = Create_Surface_Fit_5(AHL_input_pED_IPTG_INS_log10,...
    IPTG_input_pED_IPTG_INS_log10, LacZ_output_pED_IPTG_INS_log10);
%%
%
% Predict pEDL3 (broken and fixed)
%
%   this requires IPTG->Light conversion
%

% for each point from pED_IPTG_INS experiments, see whether can do the
% IPTG->light conversion, and if so, use to create the new surface function
i = 1;
predicted_light_input_pED_IPTG_INS_log10 = [];
predicted_AHL_input_pED_IPTG_INS_log10   = [];
predicted_LacZ_output_pED_IPTG_INS_log10  = [];
            
for k=1:size(IPTG_input_pED_IPTG_INS_log10,1)
    % disp(['Try to find match for ' num2str(IPTG_input_pED_IPTG_INS_log10(k,1))]);
    if (light_to_IPTG(1,2) > IPTG_input_pED_IPTG_INS_log10(k,1))
        m=1;
        % look for the best IPTG match, assuming IPTG values are decreasing
        while (m <= size(light_to_IPTG,1)) && ...
            (light_to_IPTG(m,2) > IPTG_input_pED_IPTG_INS_log10(k,1))
            % disp(['Compare ' num2str(light_to_IPTG(m,2)) ' and ' num2str(IPTG_input_pED_IPTG_INS_log10(k,1))]);
            m = m + 1;
        end
        if (m < size(light_to_IPTG,1))
            disp(['--> Found match of IPTG ' num2str(light_to_IPTG(m,2)) ' and ' num2str(IPTG_input_pED_IPTG_INS_log10(k,1))]);
            predicted_light_input_pED_IPTG_INS_log10(i,1) = light_to_IPTG(m,1);
            predicted_AHL_input_pED_IPTG_INS_log10(i,1)   = AHL_input_pED_IPTG_INS_log10(k,1);
            predicted_LacZ_output_pED_IPTG_INS_log10(i,1) = LacZ_output_pED_IPTG_INS_log10(k,1);           
            i = i + 1;
        else
            disp(['--> No match found for IPTG ' num2str(IPTG_input_pED_IPTG_INS_log10(k,1))]);
        end
    else
        disp(['--> Did not even look for match for IPTG ' num2str(IPTG_input_pED_IPTG_INS_log10(k,1))]);
    end
end
    
% First, plot data points.
figure( 'Name', 'Predicted data points for LacZ vs. AHL,Light' );
h = plot3(predicted_AHL_input_pED_IPTG_INS_log10, ...
    predicted_light_input_pED_IPTG_INS_log10, ...
    predicted_LacZ_output_pED_IPTG_INS_log10, 'r*' );
grid on;
xlabel('AHL');
ylabel('Light');
zlabel('LacZ');

% Start vals: LogEC50_1, LogEC50_2, bottom1, bottom2, top1, top2
start_vals = [0.5, 2, 0.4, 0.4, 0.14, 0.65];

[predicted_light_pED_IPTG_INS_fit, gof_2] = Create_Surface_Fit_5(predicted_AHL_input_pED_IPTG_INS_log10, ...
     predicted_light_input_pED_IPTG_INS_log10, predicted_LacZ_output_pED_IPTG_INS_log10);
%%
% 
% Convert light -> betagal -> CI
%

%num_cells = 1000000;
num_cells = 1;  %% CHECK FORUMULA!!  Values too high...
mL = 1;
minutes = 20;
 
% formula for converting MU -> LacZ levels (assuming CI and LacZ are
% approximately equivalent in effective concentrations) 
CI_levels = (10.^cf_pJT103(predicted_light_input_pED_IPTG_INS_log10)) .* (num_cells * mL * minutes * 0.5);

% for debugging purposes
global global_x_r;
global global_y_r;
global global_f_r;

% call the spatiotemporal simulator
edge_detector_spatiotemporal_simulation(10.^predicted_AHL_input_pED_IPTG_INS_log10, CI_levels, 10.^predicted_LacZ_output_pED_IPTG_INS_log10);

